import { Navigate, Outlet } from 'react-router-dom';
import { Suspense } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import { lazyImport } from '@/utils/lazyImport';
import './user.css';
import logo from '@/assets/new-logo.png';

import Loader from '@/components/Elements/Loader/Loader';
// import { EditHouseDetail } from './routes/House/EditHouseDetail';
import { MyDeal } from './routes/MyDeal/MyDeal';
import { Contracts } from './routes/Contract/Contracts';
import { ContractSignin } from './routes/Contract/ContractSignin';
import { PaymentContract } from './routes/Contract/PaymentContract';
import { Purchase } from './routes/Contract/Purchase';
import {LinkNotFound} from './routes/LinkNotFound';
import { MyLeads } from './routes/MyLeads/MyLeads';
import { PropertyOption } from './routes/PropertySaleRent/PropertyOption';
import { ReeipoServices } from './routes/ReeipoServices/ReeipoServices';
import { SubscriptionType } from './SubscriptionType/SubscriptionType';
import { AddPropertyRent } from './routes/PropertySaleRent/AddPropertyRent';
import { CompanyInvestment } from './routes/Investor/CompanyInvestment';
import { OfflinePayment } from './routes/Contract/OfflinePayment';
import { VerifyContract } from './routes/Contract/VerifyContract';
import { DraftListing } from './routes/DraftListing';
import { PaymentDone } from './routes/PaymentDone/PaymentDone';
import {ChargePayment} from '@/components/Payments/StripeCharge/ChargePayment';
import { SavedSearch } from './routes/SavedSearch';
import PhoneVerify from './components/PhoneVerify';
import {GetVerified} from './components/GetVerified';
import {GetVerifiedOtp} from './components/GetVerifiedOtp';
import { BusinessMeetingSent } from './routes/BusinessMetingSent/BusinessMeetingSent';
import { SalePaymentContract } from '../misc/routes/SaleDetail/SalePayment/SalePaymentContract';
import { SaleOfflinePayment } from '../misc/routes/SaleDetail/SalePayment/SaleOfflinePayment';
import { SaleVerifyContract } from '../misc/routes/SaleDetail/SalePayment/SaleVerifyContract';
// import { CompanyMoney } from './routes/Investor/CompanyMoney';

// const { EditBussinessSale } = lazyImport(
//   () => import('@/features/user/routes'),
//   'EditBussinessSale'
// );
const { EditPropertyProject } = lazyImport(
  () => import('@/features/user/routes'),
  'EditPropertyProject'
);
const { CompleteProfile } = lazyImport(() => import('@/features/user/routes'), 'CompleteProfile');
const { FavouriteListing } = lazyImport(() => import('@/features/user/routes'), 'FavouriteListing');
const { CreateBusiness } = lazyImport(() => import('@/features/user/routes'), 'CreateBusiness');
const { HouseRentForm } = lazyImport(() => import('@/features/user/routes'), 'HouseRentForm');
const { AddList } = lazyImport(() => import('@/features/user/routes'), 'AddList');
const { AddRentSale } = lazyImport(() => import('@/features/user/routes'), 'AddRentSale');
const { CreatePropertyProject } = lazyImport(
  () => import('@/features/user/routes'),
  'CreatePropertyProject'
);
const { Profile } = lazyImport(() => import('@/features/user/routes'), 'Profile');
const { UpdateProfile } = lazyImport(() => import('@/features/user/routes'), 'UpdateProfile');
const { MyListing } = lazyImport(() => import('@/features/user/routes'), 'MyListing');
const { Option } = lazyImport(() => import('@/features/user/routes'), 'Option');
const { ProjectMoney } = lazyImport(() => import('@/features/user/routes'), 'ProjectMoney');
// const { CompanyMoney } = lazyImport(() => import('@/features/user/routes'), 'CompanyMoney');
const { AddCompany } = lazyImport(() => import('@/features/company'), 'AddCompany');

const App = () => {
  return (
    <div>
      <Suspense
        fallback={
          <div className="w-screen h-screen alignmentLogo">
            {/* <Loader /> */}
            <img src={logo} alt="pics" />
          </div>
        }
      >
        <Header type={HeaderType.LANDING} />
        <Outlet></Outlet>
      </Suspense>
    </div>
  );
};

export const agentRoutes = [
  {
    path: '/user',
    element: <App />,
    children: [
      { path: '', element: <LinkNotFound /> },
      { path: 'profile', element: <Profile /> },
      // { path: 'get-verified', element: <GetVerified /> },
      // { path: 'get-verified-otp', element: <GetVerifiedOtp /> },
      // { path: 'update-profile', element: <UpdateProfile /> },
      // { path: 'my-deals', element: <MyDeal /> },
      // { path: 'my-leads', element: <MyLeads /> },
      // { path: 'payment-completed', element: <PaymentDone /> },
      // { path: 'contract', element: <Contracts /> },
      // { path: 'contract-signin', element: <ContractSignin /> },
      // { path: 'favourite-list', element: <FavouriteListing /> },
      { path: 'subscription-payment', element: <ChargePayment /> },
      { path: 'subscription-payment/:idSub', element: <ChargePayment /> },
      // { path: 'online-payment', element: <PaymentContract /> },
      // { path: 'offline-payment', element: <OfflinePayment /> },
      // { path: 'verify-contract', element: <VerifyContract /> },
      // { path: 'online-business-payment', element: <SalePaymentContract /> },
      // { path: 'offline-business-payment', element: <SaleOfflinePayment /> },
      // { path: 'verify-business-contract', element: <SaleVerifyContract /> },
      { path: 'complete-profile', element: <CompleteProfile /> },
      { path: 'purchase', element: <Purchase /> },
      // { path: 'edit-business-sale/:id/', element: <EditBussinessSale /> },
      // { path: 'edit-business-sale', element: <EditBussinessSale /> },
      { path: 'edit-property-project', element: <EditPropertyProject /> },
      { path: 'edit-property-project/:id/', element: <EditPropertyProject /> },
      // { path: 'edit-house-rent', element: <EditHouseDetail /> },
      // { path: 'edit-house-rent/:id/', element: <EditHouseDetail /> },
      { path: 'create-business', element: <CreateBusiness /> },
      { path: 'create-business/:id/', element: <CreateBusiness /> },
      // { path: 'create-house-rent', element: <HouseRentForm /> },
      // { path: 'create-house-rent/:id/', element: <HouseRentForm /> },
      { path: 'find-investor', element: <Option /> },
      // { path: 'select-property', element: <PropertyOption /> },
      // { path: 'add-reeipo-services', element: <ReeipoServices /> },
      { path: 'project-money', element: <ProjectMoney /> },
      { path: 'project-money/:id/', element: <ProjectMoney /> },
      // { path: 'company-money', element: <CompanyMoney /> },
      { path: 'company-money', element: <CompanyInvestment /> },
      { path: 'company-money/:id/', element: <CompanyInvestment /> },
      { path: 'add', element: <AddList /> },
      { path: 'create-property-project', element: <CreatePropertyProject /> },
      // { path: 'add-property-for-sale', element: <AddRentSale /> },
      // { path: 'add-property-for-sale/:id', element: <AddRentSale /> },
      // { path: 'add-property-for-sale/:id/', element: <AddRentSale /> },
      // { path: 'add-property-for-rent', element: <AddPropertyRent /> },
      // { path: 'add-property-for-rent/:id/', element: <AddPropertyRent /> },
      { path: 'my-listing', element: <MyListing /> },
      // { path: 'draft-listing', element: <DraftListing /> },
      // { path: 'my-bookings', element: <BusinessMeetingSent /> },
      // { path: 'saved-search', element: <SavedSearch /> },
      { path: 'create-company', element: <AddCompany /> },
      { path: 'subscription', element: <SubscriptionType /> },
      { path: '*', element: <Navigate to="/user/add" /> },
    ],
  },
];
